% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatters.R
\name{colformat_char}
\alias{colformat_char}
\title{format character cells}
\usage{
colformat_char(
  x,
  i = NULL,
  j = NULL,
  na_str = get_flextable_defaults()$na_str,
  prefix = "",
  suffix = ""
)
}
\arguments{
\item{x}{a flextable object}

\item{i}{rows selection}

\item{j}{columns selection.}

\item{na_str}{string to be used for NA values}

\item{prefix, suffix}{string to be used as prefix or suffix}
}
\description{
Format character cells in a flextable.
}
\section{Illustrations}{


\if{html}{\figure{fig_colformat_char_1.png}{options: width=50\%}}
}

\examples{
dat <- iris
z <- flextable(head(dat))
ft <- colformat_char(
  x = z, j = "Species", suffix = "!")
z <- autofit(z)
z
}
\seealso{
Other cells formatters: 
\code{\link{colformat_datetime}()},
\code{\link{colformat_date}()},
\code{\link{colformat_double}()},
\code{\link{colformat_image}()},
\code{\link{colformat_int}()},
\code{\link{colformat_lgl}()},
\code{\link{colformat_num}()},
\code{\link{compose}()},
\code{\link{set_formatter}()}
}
\concept{cells formatters}
