% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_headers.R
\name{add_header_lines}
\alias{add_header_lines}
\alias{add_footer_lines}
\title{Add a label in a header or footer new row.}
\usage{
add_header_lines(x, values = character(0), top = TRUE)

add_footer_lines(x, values = character(0), top = FALSE)
}
\arguments{
\item{x}{a \code{flextable} object}

\item{values}{a character vector, each element will be added a a new
row in the header or footer part.}

\item{top}{should the row be inserted at the top or the bottom.}
}
\description{
Add an header or footer new row made of one cell.
This is a sugar function to be used when you need to add a
title row to a flextable, most of the time it will be used in a
context of adding a footnote or adding a title on the top line
of the flextable.
}
\examples{
ft <- flextable( head( iris ) )
ft <- add_footer_lines(ft, values = "blah blah")
ft <- add_footer_lines(ft, values = c("blah 1", "blah 2"))
autofit(ft)
ft <- flextable( head( iris ) )
ft <- add_header_lines(ft, values = "blah blah")
ft <- add_header_lines(ft, values = c("blah 1", "blah 2"))
autofit(ft)
}
\seealso{
Other headers and footers: 
\code{\link{add_header_row}()},
\code{\link{add_header}()},
\code{\link{set_header_footer_df}}
}
\concept{headers and footers}
