% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regulartable.R
\name{set_formatter}
\alias{set_formatter}
\alias{set_formatter_type}
\title{set column formatter functions}
\usage{
set_formatter(x, ..., part = "body")

set_formatter_type(x, fmt_double = "\%.03f", fmt_integer = "\%.0f",
  fmt_date = "\%Y-\%m-\%d", fmt_datetime = "\%Y-\%m-\%d \%H:\%M:\%S",
  na_str = "")
}
\arguments{
\item{x}{a regulartable object}

\item{...}{Name-value pairs of functions, names should be existing col_key values}

\item{part}{partname of the table (one of 'body' or 'header' or 'footer')}

\item{fmt_double, fmt_integer}{arguments used by \code{sprintf} to
format double and integer columns.}

\item{fmt_date, fmt_datetime}{arguments used by \code{format} to
format date and date time columns.}

\item{na_str}{string for NA values}
}
\description{
Define formatter functions associated to each column key.
Functions have a single argument (the vector) and are returning the formatted
values as a character vector.
}
\section{set_formatter_type}{

\code{set_formatter_type} is an helper function to quickly define
formatter functions regarding to column types.
}

\examples{
ft <- regulartable( head( iris ) )
ft <- set_formatter( x = ft,
        Sepal.Length = function(x) sprintf("\%.02f", x),
        Sepal.Width = function(x) sprintf("\%.04f", x)
      )
ft <- theme_vanilla( ft )
ft
}
