% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.flexsurvmix.R
\name{quantile_flexsurvmix}
\alias{quantile_flexsurvmix}
\title{Quantiles of time-to-event distributions in a flexsurvmix model}
\usage{
quantile_flexsurvmix(x, newdata = NULL, B = NULL, probs = c(0.025, 0.5, 0.975))
}
\arguments{
\item{x}{Fitted model object returned from \code{\link{flexsurvmix}}.}

\item{newdata}{Data frame or list of covariate values.   If omitted for a
model with covariates, a default is used, defined by all combinations of
factors if the only covariates in the model are factors, or all covariate
values of zero if there are any non-factor covariates in the model.}

\item{B}{Number of simulations to use to compute 95\% confidence intervals,
based on the asymptotic multivariate normal distribution of the basic
parameter estimates.  If \code{B=NULL} then intervals are not computed.}

\item{probs}{Vector of alternative quantiles, by default \code{c(0.025, 0.95, 0.975)}
giving the median and a 95\% interval.}
}
\description{
This returns the quantiles of each event-specific parametric time-to-event
distribution in the mixture model, which describes the time to the event
conditionally on that event being the one that happens.
}
