% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flatxml.r
\name{fxml_getParent}
\alias{fxml_getParent}
\title{Parent of an XML element}
\usage{
fxml_getParent(xmlflat.df, elemid)
}
\arguments{
\item{xmlflat.df}{A flat XML dataframe created with \code{\link{fxml_importXMLFlat}}.}

\item{elemid}{The ID of the XML element. The ID is the value of the \code{elemid.} field in the flat XML dataframe.}
}
\value{
The ID (\code{xmlflat.df$elemid.}) of the parent node of the XML element with ID \code{elemid}. If no parent exists (because XML node \code{elemid} is the root node of the XML document) then \code{NULL} is returned.
}
\description{
Returns the parent of an XML element.
}
\examples{
# Load example file with population data from United Nations Statistics Division
# and create flat dataframe
example <- system.file("worldpopulation.xml", package="flatxml")
xml.dataframe <- fxml_importXMLFlat(example)

# Get the ID of the parent element of the XML element with ID 4 (xml.dataframe$elemid. ==  4)
fxml_getParent(xml.dataframe, 4)
}
\seealso{
\code{\link{fxml_hasParent}}
}
\author{
Joachim Zuckarelli \email{joachim@zuckarelli.de}
}
