% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JPtest.R
\name{levelplot.JPtest}
\alias{levelplot.JPtest}
\title{Levelplot method for data in a \code{JPtest} object}
\usage{
\method{levelplot}{JPtest}(JPobj, what = "pvalues", rotate = TRUE, plot = TRUE, ...)
}
\arguments{
\item{JPobj}{the \code{JPtest} object to plot.}

\item{what}{a character or an integer. Which component of the \code{test}
entry in \code{JPobj} should be plotted? Can be any of \emph{projections},
\emph{statistics}, \emph{pvalues} or, respectively, 1, 2 or 3.}

\item{rotate}{a logical. Should the matrix containing the data be transposed
before plotting? By default in \code{lattice::levelplot.matrix}, the rows of
the plotted matrix correspond to the x-axis.}

\item{plot}{a logical. Should the lattice object be plotted?}

\item{...}{further arguments passed to the \code{lattice::levelplot}
function.}
}
\value{
An object of class \code{trellis}, invisibly.
}
\description{
Plot a chosen result matrix contained in the \emph{test} entry of a
\code{JPtest} object. The underlying function is the
\code{lattice::levelplot.matrix} function.
}
