% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/light_interaction.R
\name{light_interaction}
\alias{light_interaction}
\alias{light_interaction.default}
\alias{light_interaction.flashlight}
\alias{light_interaction.multiflashlight}
\title{Interaction Strength}
\usage{
light_interaction(x, ...)

\method{light_interaction}{default}(x, ...)

\method{light_interaction}{flashlight}(
  x,
  data = x$data,
  by = x$by,
  v = NULL,
  pairwise = FALSE,
  type = c("H", "ice"),
  normalize = TRUE,
  take_sqrt = TRUE,
  grid_size = 30,
  n_max = 300,
  seed = NULL,
  use_linkinv = FALSE,
  value_name = "value",
  error_name = "error",
  label_name = "label",
  variable_name = "variable",
  ...
)

\method{light_interaction}{multiflashlight}(x, ...)
}
\arguments{
\item{x}{An object of class \code{flashlight} or \code{multiflashlight}.}

\item{...}{Further arguments passed to or from other methods.}

\item{data}{An optional \code{data.frame}.}

\item{by}{An optional vector of column names used to additionally group the results.}

\item{v}{Vector of variables to be assessed.}

\item{pairwise}{Should overall interaction strength per variable be shown or pairwise interactions? Defaults to \code{FALSE}.}

\item{type}{Are measures based on Friedman's H statistic ("H") or on "ice" curves? Option "ice" is available only if \code{pairwise = FALSE}.}

\item{normalize}{Should the variances explained be normalized? Default is \code{TRUE} in order to reproduce Friedman's H statistic.}

\item{take_sqrt}{In order to reproduce Friedman's H statistic, resulting values are root transformed. Set to \code{FALSE} if squared values should be returned.}

\item{grid_size}{Grid size used to form the outer product. Will be randomly picked from data (after limiting to \code{n_max}).}

\item{n_max}{Maximum number of data rows to consider. Will be randomly picked from \code{data} if necessary.}

\item{seed}{An integer random seed used for subsampling.}

\item{use_linkinv}{Should retransformation function be applied? Default is FALSE.}

\item{value_name}{Column name in resulting \code{data} containing the interaction strenght. Defaults to "value".}

\item{error_name}{Currently not used.}

\item{label_name}{Column name in resulting \code{data} containing the label of the flashlight. Defaults to "label".}

\item{variable_name}{Column name in resulting \code{data} containing the variable names. Defaults to "variable".}
}
\value{
An object of class \code{light_importance}, \code{light} (and a list) with the following elements.
\itemize{
  \item \code{data} A tibble containing the results. Can be used to build fully customized visualizations. Its column names are specified by the items in this list (except for "method").
  \item \code{by} Same as input \code{by}.
  \item \code{value_name} Same as input \code{value_name}.
  \item \code{error_name} Same as input \code{error_name}.
  \item \code{label_name} Same as input \code{label_name}.
  \item \code{variable_name} Same as input \code{variable_name}.
}
}
\description{
This function provides Friedman's H statistic [1] for overall interaction strength per covariable as well as its version for pairwise interactions. As a fast alterantive to assess overall interaction strength, with \code{type = "ice"}, the function offers a method based on centered ICE curves: The corresponding H* statistic measures how much of the variability of a c-ICE curve is unexplained by the main effect. As for Friedman's H statistic, it can be useful to consider unnormalized or squared values (see Details below).
}
\details{
Friedman's H statistic relates the interaction strength of a variable (pair) to the total effect strength of that variable (pair) based on partial dependence curves. Due to this normalization step, even variables with low importance can have high values for H. The function \code{light_interaction} offers the option to skip this normalization step in order to have a more direct comparison of the interaction effects across variable (pairs). The values of such unnormalized H are on the scale of the response variable. Use \code{take_sqrt = FALSE} to return squared values of H. Note that in general, for each variable (pair) predicitons are done on a data set with \code{grid_size * n_max}, so be cautious with increasing the defaults too much.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default method not implemented yet.

\item \code{flashlight}: Interaction strengths for a flashlight object.

\item \code{multiflashlight}: for a multiflashlight object.
}}

\examples{
fit_additive <- lm(Sepal.Length ~ Petal.Length + Petal.Width + Species, data = iris)
fit_nonadditive <- lm(Sepal.Length ~ Petal.Length * Petal.Width + Species, data = iris)
fl_additive <- flashlight(model = fit_additive, label = "additive")
fl_nonadditive <- flashlight(model = fit_nonadditive, label = "nonadditive")
fls <- multiflashlight(list(fl_additive, fl_nonadditive), data = iris, y = "Sepal.Length")
x <- fls$nonadditive
plot(st <- light_interaction(fls))
plot(light_interaction(fls, pairwise = TRUE))
}
\references{
[1] Friedman, J. H. and Popescu, B. E. (2008). “Predictive learning via rule ensembles.” The Annals of Applied Statistics. JSTOR, 916–54..
}
\seealso{
\code{\link{light_ice}}.
}
