% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MiscFuns.R
\docType{data}
\name{i}
\alias{i}
\alias{interact}
\title{Interact variables with factors}
\format{
An object of class \code{function} of length 1.
}
\usage{
i(var, fe, ref, drop, keep)

interact
}
\arguments{
\item{var}{A vector.}

\item{fe}{A vector (of any type). Must be of the same length as \code{var}.}

\item{ref}{A single value that belongs to the interacted variable (\code{fe}). Can be missing.}

\item{drop}{A vector of values that belongs to the interacted variable (\code{fe}). If provided, all values from \code{fe} that match \code{drop} will be removed.}

\item{keep}{A vector of values that belongs to the interacted variable (\code{fe}). If provided, only the values from \code{fe} that match \code{keep} will be kept.}
}
\value{
It returns a matrix with number of rows the length of \code{var}. The number of columns is equal to the number of cases contained in \code{fe} minus the reference.
}
\description{
Interacts a variable with another treated as a factor, and sets a reference
}
\section{Shorthand in \code{fixest} estimations}{

In \code{fixest} estimations, instead of using \code{i(var, fe, ref)}, you can instead use the following writing \code{var::fe(ref)}.
}

\examples{

#
# Simple illustration
#

x = rnorm(10)
y = rep(1:4, 3)[1:10]

cbind(x, y, i(x, y, 1))

#
# In fixest estimations
#

# NOTA: in fixest estimations, i(var, fe, ref) is equivalent to var::fe(ref)

data(base_did)
# We interact the variable 'period' with the variable 'treat'
est_did = feols(y ~ x1 + i(treat, period, 5) | id+period, base_did)

# You could have used the following formula instead:
# y ~ x1 + treat::period(5) | id+period

}
\seealso{
\code{\link[fixest]{coefplot}} to plot interactions, \code{\link[fixest]{feols}} for OLS estimation with multiple fixed-effects.
}
\author{
Laurent Berge
}
\keyword{datasets}
