% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Methods.R
\name{deviance.fixest}
\alias{deviance.fixest}
\title{Extracts the deviance of a fixest estimation}
\usage{
\method{deviance}{fixest}(object, ...)
}
\arguments{
\item{object}{A \code{fixest} object.}

\item{...}{Not currently used.}
}
\value{
Returns a numeric scalar equal to the deviance.
}
\description{
Returns the deviance from a \code{fixest} estimation.
}
\examples{

est = feols(Petal.Length ~ Petal.Width, iris)
deviance(est)

est_pois = fepois(Petal.Length ~ Petal.Width, iris)
deviance(est_pois)

}
\seealso{
\code{\link[fixest]{feols}}, \code{\link[fixest:feglm]{fepois}}, \code{\link[fixest]{feglm}}, \code{\link[fixest:femlm]{fenegbin}}, \code{\link[fixest]{feNmlm}}.
}
