% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MiscFuns.R
\name{esttex}
\alias{esttex}
\title{Facility to export the results of multiple \code{fixest} estimations in a Latex table.}
\usage{
esttex(..., se = c("standard", "white", "cluster", "twoway", "threeway",
  "fourway"), dof = TRUE, cluster, digits = 4, pseudo = TRUE, title,
  sdBelow = TRUE, drop, order, dict = getFixest_dict(), file,
  replace = FALSE, convergence, signifCode = c(`***` = 0.01, `**` =
  0.05, `*` = 0.1), label, aic = FALSE, sqCor = FALSE, subtitles,
  fixef_sizes = FALSE, bic = TRUE, loglik = FALSE,
  yesNoFixef = c("Yes", "No"), keepFactors = TRUE, family,
  powerBelow = -5)
}
\arguments{
\item{...}{Used to capture different \code{fixest} objects (obtained with \code{\link[fixest]{femlm}}, \code{\link[fixest]{feols}} or \code{\link[fixest]{feglm}}). Note that any other type of element is discarded. Note that you can give a list of \code{fixest} objects.}

\item{se}{Character scalar. Which kind of standard error should be computed: \dQuote{standard}, \dQuote{White}, \dQuote{cluster}, \dQuote{twoway}, \dQuote{threeway} or \dQuote{fourway}? By default if there are clusters in the estimation: \code{se = "cluster"}, otherwise \code{se = "standard"}. Note that this argument can be implicitly deduced from the argument \code{cluster}.}

\item{dof}{Logical, default is \code{TRUE}. Should there be a degree of freedom correction to the standard errors of the coefficients?}

\item{cluster}{Tells how to cluster the standard-errors (if clustering is requested). Can be either a list of vectors, a character vector of variable names, a formula or an integer vector. Assume we want to perform 2-way clustering over \code{var1} and \code{var2} contained in the data.frame \code{base} used for the estimation. All the following \code{cluster} arguments are valid and do the same thing: \code{cluster = base[, c("var1, "var2")]}, \code{cluster = c("var1, "var2")}, \code{cluster = ~var1+var2}. If the two variables were used as clusters in the estimation, you could further use \code{cluster = 1:2} or leave it blank with \code{se = "twoway"} (assuming \code{var1} [resp. \code{var2}] was the 1st [res. 2nd] cluster).}

\item{digits}{Integer, default is 4. The number of digits to be displayed.}

\item{pseudo}{Logical, default is \code{TRUE}. Should the pseudo R2 be displayed?}

\item{title}{Character scalar. The title of the Latex table.}

\item{sdBelow}{Logical, default is \code{TRUE}. Should the standard-errors be displayed below the coefficients?}

\item{drop}{Character vector. This element is used if some variables are not to be displayed. This should be a regular expression (see \code{\link[base]{regex}} help for more info). There can be more than one regular expression. Each variable satisfying the regular expression will be discarded.}

\item{order}{Character vector. This element is used if the user wants the variables to be ordered in a certain way. This should be a regular expression (see \code{\link[base]{regex}} help for more info). There can be more than one regular expression. The variables satisfying the first regular expression will be placed first, then the order follows the sequence of regular expressions.}

\item{dict}{A named character vector. It changes the original variable names to the ones contained in the \code{dict}. E.g. to change the variables named \code{a} and \code{b3} to (resp.) \dQuote{$log(a)$} and to \dQuote{$bonus^3$}, use \code{dict=c(a="$log(a)$",b3="$bonus^3$")}. By default it is equal to \code{getFixest_dict()}, a default dictionary can be set with \code{\link[fixest]{setFixest_dict}}.}

\item{file}{A character scalar. If provided, the Latex table will be saved in a file whose path is \code{file}.}

\item{replace}{Logical, default is \code{FALSE}. Only used if option \code{file} is used. Should the Latex table be written in a new file that replaces any existing file?}

\item{convergence}{Logical, default is missing. Should the convergence state of the algorithm be displayed? By default, convergence information is displayed if at least one model did not converge.}

\item{signifCode}{Named numeric vector, used to provide the significance codes with respect to the p-value of the coefficients. Default is \code{c("***"=0.01, "**"=0.05, "*"=0.10)}.}

\item{label}{Character scalar. The label of the Latex table.}

\item{aic}{Logical, default is \code{FALSE}. Should the AIC be displayed?}

\item{sqCor}{Logical, default is \code{FALSE}. Should the squared correlation be displayed?}

\item{subtitles}{Character vector of the same length as the number of models to be displayed. If provided, subtitles are added underneath the dependent variable name.}

\item{fixef_sizes}{Logical, default is \code{FALSE}. If \code{TRUE} and fixed-effects were used in the models, then the number "individuals" per fixed-effect dimension is also displayed.}

\item{bic}{Logical, default is \code{TRUE}.Should the BIC be reported?}

\item{loglik}{Logical, default is \code{TRUE}. Should the log-likelihood be reported?}

\item{yesNoFixef}{A character vector of length 2. Default is \code{c("Yes", "No")}. This is the message displayed when a given cluster is (or is not) included in a regression.}

\item{keepFactors}{Logical, default is \code{TRUE}. If \code{FALSE}, then factor variables are displayed as fixed-effects and no coefficient is shown.}

\item{family}{A logical, default is missing. Whether to display the families of the models. By default this line is displayed when at least two models are from different families.}

\item{powerBelow}{Integer, default is -5. A coefficient whose value is below \code{10**(powerBelow+1)} is written with a power in Latex. For example \code{0.0000456} would be written \code{4.56$\\times 10^{-5}$} by default. Setting \code{powerBelow = -6} would lead to \code{0.00004} in Latex.}
}
\value{
There is nothing returned, the result is only displayed on the console or saved in a file.
}
\description{
This function aggregates the results of multiple estimations and display them in the form of  one Latex table whose row names are the variables and the columns contain the coefficients and standard-errors.
}
\examples{

# two fitted models with different expl. variables:
res1 = femlm(Sepal.Length ~ Sepal.Width + Petal.Length +
             Petal.Width | Species, iris)
res2 = femlm(Sepal.Length ~ Petal.Width | Species, iris)

# We export the three results in one Latex table,
# with clustered standard-errors:
esttex(res1, res2, se = "cluster")

# Changing the names & significance codes
esttex(res1, res2, dict = c(Sepal.Length = "The sepal length", Sepal.Width = "SW"),
        signifCode = c("**" = 0.1, "*" = 0.2, "n.s."=1))

}
\seealso{
See also the main estimation functions \code{\link[fixest]{femlm}}, \code{\link[fixest]{feols}} or \code{\link[fixest]{feglm}}. Use \code{\link[fixest]{summary.fixest}} to see the results with the appropriate standard-errors, \code{\link[fixest]{fixef.fixest}} to extract the cluster coefficients, and the functions \code{\link[fixest]{esttable}} and \code{\link[fixest]{esttex}} to visualize the results of multiple estimations.
}
\author{
Laurent Berge
}
