% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/term-class.R
\name{term}
\alias{term}
\alias{term.numeric}
\alias{term.Term}
\alias{term.Date}
\title{Create Term class}
\usage{
term(x, ...)

\method{term}{numeric}(x, units = "days", ...)

\method{term}{Term}(x, ...)

\method{term}{Date}(x, end_date, calendar, ...)
}
\arguments{
\item{x}{can be a numeric value representing the time period, a Term object,
or the initial date for a period between two dates.}

\item{...}{additional arguments}

\item{units}{one of the valid \code{units}: \code{days}, \code{monts},
\code{years}.}

\item{end_date}{the final date for a period between two dates.}

\item{calendar}{the calendar used to compute the amount of days for a period
between two dates.}
}
\value{
A \code{Term} object.
}
\description{
\code{term()} creates a Term object.
}
\examples{
term(6, "months")
if (require("bizdays")) {
  term(as.Date("2022-02-02"), as.Date("2022-02-23"), "Brazil/ANBIMA")
}
}
