% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/daycount-class.R
\name{term-conversion}
\alias{term-conversion}
\alias{toyears,Daycount,Term-method}
\alias{tomonths,Daycount,Term-method}
\alias{todays,Daycount,Term-method}
\alias{toyears}
\alias{tomonths}
\alias{todays}
\title{Convert Term in different units}
\usage{
toyears(x, t)

tomonths(x, t)

todays(x, t)
}
\arguments{
\item{x}{a Daycount object.}

\item{t}{a Term object.}
}
\value{
A Term object converted to the units accordingly the used function.
}
\description{
\code{toyears}, \code{tomonths} and \code{todays} functions convert Term objects according
to Daycount.
}
\details{
\code{toyears} returns the given Term in years units.
\code{tomonths} returns the given Term in months units.
\code{todays} returns the given Term in days units.
}
\examples{
dc <- daycount("actual/360")
t <- term(10, "months")
toyears(dc, t)
tomonths(dc, t)
todays(dc, t)
}
