% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/z_footywire-results.R
\name{get_footywire_match_results}
\alias{get_footywire_match_results}
\title{Get footywire Match Results}
\usage{
get_footywire_match_results(season, last_n_matches = NULL)
}
\arguments{
\item{season}{season to return results for}

\item{last_n_matches}{number of matches to return, starting from the most recent}
}
\value{
Returns a data frame of match results from the year and number of results
}
\description{
Returns the results of matches played in a particular season. You can limit how many results you return with the \code{last_n_results} parameter.
}
\details{
For example - you might just want to return the results from last round so you'd set \code{last_n_results = 9}.

If you want to return a large amount of results, it is more efficient to use \code{get_match_results()} however this can sometimes take some time to update the latest rounds results.
}
\examples{
\dontrun{
get_footywire_match_results(2020, last_n_matches = 5)
}
}
