% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitbit_utils.R
\name{heart_rate_time_series}
\alias{heart_rate_time_series}
\title{heart rate activity time series}
\usage{
heart_rate_time_series(
  user_id,
  token,
  date_start,
  date_end,
  time_start = "00:00",
  time_end = "23:59",
  detail_level = "1min",
  ggplot_intraday = FALSE,
  ggplot_ncol = NULL,
  ggplot_nrow = NULL,
  verbose = FALSE,
  show_nchar_case_error = 135
)
}
\arguments{
\item{user_id}{a character string specifying the encoded ID of the user. For instance '99xxxx' of the following URL 'https://www.fitbit.com/user/99xxxx' of the user's account corresponds to the 'user_id'}

\item{token}{a character string specifying the secret token that a user receives when registers a new application in https://dev.fitbit.com/apps}

\item{date_start}{a character string specifying a start Date. For instance, the date '2021-12-31' where the input order is 'year-month-day'}

\item{date_end}{a character string specifying a end Date. For instance, the date '2021-12-31' where the input order is 'year-month-day'}

\item{time_start}{a character string specifying the start time. For instance, the time '00:00' where the input order is 'hours-minutes'}

\item{time_end}{a character string specifying the end time. For instance, the time '23:59' where the input order is 'hours-minutes'}

\item{detail_level}{a character string specifying the detail level of the heart rate time series. It can be either '1min' or '1sec', for 1-minute and 1-second intervals}

\item{ggplot_intraday}{a boolean. If TRUE then the ggplot of the heart rate time series will be returned too}

\item{ggplot_ncol}{either NULL or an integer specifying the number of columns of the output ggplot}

\item{ggplot_nrow}{either NULL or an integer specifying the number of rows of the output ggplot}

\item{verbose}{a boolean. If TRUE then information will be printed out in the console}

\item{show_nchar_case_error}{an integer that specifies the number of characters that will be returned in case on an error. The default value is 135 characters.}
}
\value{
an object of class list
}
\description{
heart rate activity time series
}
\examples{

\dontrun{

require(fitbitViz)

USER_ID = '99xxxx'
token = 'my_long_web_api_token'

heart_dat = heart_rate_time_series(user_id = USER_ID,
                                   token = token,
                                   date_start = '2021-03-09',
                                   date_end = '2021-03-16',
                                   time_start = '00:00',
                                   time_end = '23:59',
                                   detail_level = '1min',
                                   ggplot_intraday = TRUE,
                                   verbose = TRUE,
                                   show_nchar_case_error = 135)
heart_dat$plt
heart_dat$heart_rate
heart_dat$heart_rate_intraday

}
}
