% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitbit_utils.R
\name{extend_AOI_buffer}
\alias{extend_AOI_buffer}
\title{Extract the sf-object and raster extent based on a buffer (in meters)}
\usage{
extend_AOI_buffer(
  dat_gps_tcx,
  buffer_in_meters = 1000,
  CRS = 4326,
  verbose = FALSE
)
}
\arguments{
\item{dat_gps_tcx}{this parameter corresponds to the output data.table of the 'GPS_TCX_data()' function}

\item{buffer_in_meters}{an integer value specifying the buffer in meters. The bounding box of the input coordinates (longitudes, latitudes) will be extended by that many meters. The default value is 1000 meters.}

\item{CRS}{an integer specifying the Coordinates Reference System. The recommended value for this data is 4326 (which is also the default value)}

\item{verbose}{a boolean. If TRUE then information will be printed out in the console}
}
\value{
an object of class list
}
\description{
Extract the sf-object and raster extent based on a buffer (in meters)
}
\details{
To create the buffer in meters using the 'sf' package I had to transform to another projection - by default I've used 7801 - as suggested in the following stackoverflow thread, https://stackoverflow.com/a/54754935/8302386
}
\examples{

\dontrun{

require(fitbitViz)

#............................
# first extract the log-id(s)
#............................

USER_ID = '99xxxx'
token = 'my_long_web_api_token'

log_id = extract_LOG_ID(user_id = USER_ID,
                        token = token,
                        after_Date = '2021-03-13',
                        limit = 10,
                        sort = 'asc',
                        verbose = TRUE)
str(log_id)

#...................................
# then return the gps-ctx data.table
#...................................

res_tcx = GPS_TCX_data(log_id = log_id,
                       user_id = USER_ID,
                       token = token,
                       time_zone = 'Europe/Athens',
                       verbose = TRUE)
str(res_tcx)

#....................................................
# then compute the sf-object buffer and raster-extend
#....................................................

sf_rst_ext = extend_AOI_buffer(dat_gps_tcx = res_tcx,
                               buffer_in_meters = 1000,
                               CRS = 4326,
                               verbose = TRUE)
sf_rst_ext

}
}
