% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitPoly.r
\docType{data}
\name{fitPoly_data}
\alias{fitPoly_data}
\title{Small fitPoly input datasets for testing and examples}
\usage{
data(fitPoly_data)
}
\description{
A list with small datasets of four different
ploidy levels for testing and examples
}
\details{
list fitPoly_data contains the following items:
\itemize{
 \item ploidy2: a diploid dataset with only the SNP array signal ratios
 \item ploidy3: a triploid dataset with in addition to the signal ratios
                two data.frames specifying the population structure
 \item ploidy4: a tetraploid dataset similar to the triploid dataset and
                additionally prior dosage information of the F1 population parents
                and of a few other samples
 \item ploidy6: a hexaploid dataset similar to the tetraploid dataset and
                additionally the 7 starting means for some of the markers
}
Each of the items contains one or more elements, postfixed by 2x, 3x, 4x or 6x
depending on the ploidy:
\itemize{
 \item dat: a data.frame with at least columns MarkerName, SampleName and ratio
 with the signal ratios to be analyzed
 \item pop: a data.frame with columns SampleName and Population, specifying the
 population to which each sample belongs
 \item pop.par: a matrix specifying what are the parents of each population (if any)
 \item parPriors: a data.frame specifying prior known allele dosages for the F1 parents
 \item sampPriors: a data.frame specifying the prior known dosages for other samples
 \item startmeans: a data.frame with prior known means for the (ploidy+1) mixture model
 components
}
In addition the ploidy6 component has elements pop and pop.parents (no suffix)
which are equivalent to pop6x and pop.par6x, in the format required
by function codomMarker.
}
