% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sign_in.R
\name{sign_in}
\alias{sign_in}
\title{Sign in a user with email & password}
\usage{
sign_in(email, password)
}
\arguments{
\item{email}{User email}

\item{password}{User password}
}
\value{
A named list with the following items:
\itemize{
\item \code{idToken}: A Firebase Auth ID token for the authenticated user.
\item \code{email}: The email for the authenticated user.
\item \code{refreshToken}: A Firebase Auth refresh token for the authenticated user.
\item \code{expiresIn}: The number of seconds in which the ID token expires.
\item \code{localId}: The uid of the authenticated user.
\item \code{registered}: Whether the email is for an existing account.
\item \code{error}:
\itemize{
\item \code{NULL} if no error code in response
\item A list of 2 if response was an error:
\itemize{
\item \code{code}: Error code
\item \code{message}: Error message
}
}
}
}
\description{
Sign in a user with email & password
}
\details{
Visit \href{https://firebase.google.com/docs/reference/rest/auth#section-sign-in-email-password}{Firebase Auth REST API docs}
for more details
}
\examples{
\dontrun{
  sign_in(email = "user-email", password = "strong-password")
}
}
