% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/caching.R
\name{caching}
\alias{caching}
\title{Caching FinBIF downloads}
\description{
Working with cached data from FinBIF.
}
\section{Turning caching off}{

By default, local caching of most FinBIF API requests is turned on. Any
request made using the same arguments will only request data from FinBIF in
the first instance and subsequent requests will use the local cache while it
exists. This will increase the speed of repeated requests and save bandwidth
and computation for the FinBIF server. Caching can be turned off temporarily
by setting the \code{cache = FALSE} in the requesting function.

Setting \code{options(finbif_use_cache = FALSE)} will turn off caching for the
current session.
}

\section{Using filesystem caching}{

By default cached requests are stored in memory. This can be changed by
setting the file path for the current session with
\code{options(finbif_cache_path = "path/to/cache")}.
}

\section{Using database caching}{

Caching can also be done using a database. Using a database for caching
requires the packages \code{DBI}, \code{blob} and a database backend package such as
\code{RSQLite} to be installed. To use the database for caching simply pass the
connection objected created with \code{DBI::dbConnect} to the \code{finbif_cache_path}
option (e.g.,
\code{db <- DBI::dbConnect(RSQLite::SQLite(), "my-db.sqlite"); }
\code{options(finbif_cache_path = db)}
).
}

\section{Clearing the cache}{

The cache files can deleted \code{finbif_clear_cache()}.
}

