% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map-utils.R
\name{hist_xy}
\alias{hist_xy}
\title{2-Dimensional Histogram}
\usage{
hist_xy(xy, breaks)
}
\arguments{
\item{xy}{Numeric. A \code{data.frame}, or object coercible to a \code{data.frame}
with \code{as.data.frame()}, where the columns of the \code{data.frame} are,
or can be, interpreted as XY coordinates.}

\item{breaks}{List. A list of vectors, one for each dimension of \code{xy}, where
each vector gives the breakpoints between the histogram cells.}
}
\value{
A list with three components:
\itemize{
\item \code{x} The X dimension breakpoints.
\item \code{y} The Y dimension breakpoints.
\item \code{z} A frequency table of the number of \code{xy} points in each cell.
}
}
\description{
Compute a histogram from xy data given set of breakpoints. The finbif package
mapping utilities have been deprecated and will be removed in the next
release.
}
\examples{
set.seed(1L)
hist_xy(matrix(runif(50), 25), list(seq(0, 1, .2), seq(0, 1, .2)))
}
