% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map-utils.R
\name{breaks_xy}
\alias{breaks_xy}
\title{Create XY Breakpoints}
\usage{
breaks_xy(bbox, size)
}
\arguments{
\item{bbox}{Numeric vector. A vector of points of the form,
\code{c(xmin, ymin, xmax, ymax)} giving the outer limits of the breakpoints when
expanded to nearest multiple of \code{size}.}

\item{size}{Numeric. The size of the cells between the breakpoints.}
}
\value{
A list with two components:
\itemize{
\item \code{x} The X dimension breakpoints.
\item \code{y} The Y dimension breakpoints.
}
}
\description{
Creates sets of equally spaced breakpoints for XY coordinate data.
}
\examples{
breaks_xy(c(5, -45, 67, 100), 10)
}
