% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryfactorlist.R
\name{summary_factorlist_stratified}
\alias{summary_factorlist_stratified}
\title{Summarise a set of factors (or continuous variables) by a dependent variable}
\usage{
summary_factorlist_stratified(
  .data,
  ...,
  split,
  colname_sep = "|",
  level_max_length = 10,
  n_common_cols = 2
)
}
\arguments{
\item{.data}{Dataframe.}

\item{...}{Arguments to \code{\link{summary_factorlist}}.}

\item{split}{Quoted variable name to stratify columns by.}

\item{colname_sep}{Separator for creation of new column name.}

\item{level_max_length}{Maximum name for each factor level contributing to column name.}

\item{n_common_cols}{Number of common columns in \code{\link{summary_factorlist}} table, usually 2.}
}
\value{
Dataframe.
}
\description{
A function that takes a single dependent variable with a vector of
explanatory variable names (continuous or categorical variables) to produce a
summary table.
}
\details{
This function aims to produce publication-ready summary tables for
categorical or continuous dependent variables. It usually takes a categorical
dependent variable to produce a cross table of counts and proportions
expressed as percentages or summarised continuous explanatory variables.
However, it will take a continuous dependent variable to produce mean
(standard deviation) or median (interquartile range) for use with linear
regression models.
Stratify a \code{\link{summary_factorlist}} table (beta testing)
}
\examples{
# Table 1 - Perforation status stratified by sex ----
explanatory = c("age", "obstruct.factor")
dependent = "perfor.factor"

# Single split
colon_s \%>\%
  summary_factorlist_stratified(dependent, explanatory, split = c("sex.factor"))

# Double split
colon_s \%>\%
 summary_factorlist_stratified(dependent, explanatory, split = c("sex.factor", "age.factor"))
}
