% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ff_remove_ref.R
\name{ff_remove_ref}
\alias{ff_remove_ref}
\alias{finalfit_remove_ref}
\title{Remove regression reference level row from table}
\usage{
ff_remove_ref(.data)

finalfit_remove_ref(.data)
}
\arguments{
\item{.data}{Output from \code{\link{finalfit}} or similar.}
}
\value{
Dataframe.
}
\description{
This looks for a column with a name including "Coefficient", "OR", or "HR"
(\code{\link{finalfit}} defaults) and removes any rows with "-" (the default
for the reference level). Can also be combined to produce an
\code{\link{or_plot}}, see below.
}
\examples{
# Table example
explanatory = c("age.factor", "age", "sex.factor", "nodes", "obstruct.factor", "perfor.factor")
dependent = 'mort_5yr'
colon_s \%>\%
	 finalfit(dependent, explanatory, add_dependent_label = FALSE) \%>\%
	 ff_remove_ref() \%>\%
	 dependent_label(colon_s, dependent)
	
# Plot example
explanatory = c("age.factor", "age", "sex.factor", "nodes", "obstruct.factor", "perfor.factor")
dependent = 'mort_5yr'
colon_s \%>\% 
  summary_factorlist(dependent, explanatory, total_col = TRUE, fit_id=TRUE) \%>\% 
  ff_merge(
    glmuni(colon_s, dependent, explanatory) \%>\% 
    fit2df()) \%>\% 
  ff_remove_ref() \%>\% 
  dplyr::select(-`OR`) -> factorlist_plot

colon_s \%>\% 
   or_plot(dependent, explanatory, factorlist = factorlist_plot)
}
