% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{AllEqual}
\alias{AllEqual}
\title{A more flexible version of \link{all.equal}.}
\usage{
AllEqual(a, b = NULL)
}
\arguments{
\item{a}{A vector.}

\item{b}{Either \code{NULL} or a vector of length either 1 or \code{length(a)}}
}
\value{
\code{TRUE} if "equality of all" is satisfied (as detailed in
"Description" above) and \code{FALSE} otherwise.
}
\description{
If one argument is specified, check that all elements of that argument are
equal. If two arguments of equal length are specified, check equality of all
of their corresponding elements. If two arguments are specified, \code{a} of
length 1 and \code{b} of length greater than 1, check that all elements of
\code{b} are equal to the element in a. If two arguments are specified, \code{a} of
length greater than 1 and \code{b} of 1, check that all elements of
\code{a} are equal to the element in \code{b}.
}
\examples{
AllEqual(1, rep(1, 3))
AllEqual(2, 1:3)
AllEqual(1:4, 1:4)
AllEqual(1:4, c(1, 2, 3, 3))
AllEqual(rep(1, 10))
AllEqual(c(1, 88))
}
