% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernels.R
\name{kernels}
\alias{kernels}
\alias{SE}
\alias{LINEAR}
\title{Multivariate RBF Kernel}
\usage{
SE(X, sigma = 1, rho = median(as.matrix(dist(t(X)))), jitter = 1e-10)

LINEAR(X, sigma = 1, c = rep(0, nrow(X)))
}
\arguments{
\item{X}{covariate (dimension Q x N; i.e., covariates x samples)}

\item{sigma}{scalar parameter}

\item{rho}{scalar bandwidth parameter}

\item{jitter}{small scalar to add to off-diagonal of gram matrix 
(for numerical underflow issues)}

\item{c}{vector parameter defining intercept for linear kernel}
}
\value{
Gram Matrix (N x N) (e.g., the Kernel evaluated at 
each pair of points)
}
\description{
Designed to be partially specified. (see examples)
}
\details{
Gram matrix G is given by 

SE (squared exponential):
\deqn{G = \sigma^2 * exp(-[(X-c)'(X-c)]/(s*\rho^2))}

LINEAR:
\deqn{G = \sigma^2*(X-c)'(X-c)}
}
