% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design.R
\name{fhir_load_design}
\alias{fhir_load_design}
\title{Load design from xml}
\usage{
fhir_load_design(file)
}
\arguments{
\item{file}{A string specifying the file from which to read}
}
\value{
A list representing a valid design for \code{\link{fhir_crack}}
}
\description{
Loads a design for use with \code{\link{fhir_crack}} from an xml file into R
}
\examples{

#create and save design
design <- list(
   Pat = list(
      resource = "//Patient",
      cols = "./*"
   )

)
temp <- tempfile()

fhir_save_design(design, file = temp)
design <- fhir_load_design(temp)
}
