% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fhircrack.R
\name{fhir_common_columns}
\alias{fhir_common_columns}
\title{Find common columns}
\usage{
fhir_common_columns(data_frame, column_names_prefix)
}
\arguments{
\item{data_frame}{A data frame with automatically named columns as produced by \code{\link{fhir_crack}}.}

\item{column_names_prefix}{A string containing the common prefix of the desired columns.}
}
\value{
A character vector with the names of all columns matching \code{column_names_prefix}.
}
\description{
This is a convenience function to find all column names in a data frame starting with the same string that can
then be used for \code{\link{fhir_melt}}.
}
\details{
It is intended for use on data frames with column names that have been automatically produced by \code{\link{fhir_crack}}
and follow the form \code{level1.level2.level3} such as \code{name.given.value} or \code{code.coding.system.value}.
Note that this function will only work on column names following exactly this schema.

The resulting character vector can be used for melting all columns belonging to the same attribute in an indexed data frame, see \code{?fhir_melt}.
}
\examples{
#unserialize example bundles
bundles <- fhir_unserialize(medication_bundles)

#crack Patient Resources
design <- list(
  Patients = list(".//Patient")
)

dfs <- fhir_crack(bundles, design)

#look at automatically generated names
names(dfs$Patients)

#extract all column names beginning with the string "name"
fhir_common_columns(data_frame = dfs$Patients, column_names_prefix = "name")
}
