% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/full_information.R
\name{kernel_normal}
\alias{kernel_normal}
\alias{kernel_normal.default}
\alias{kernel_normal.numeric}
\alias{kernel_normal.matrix}
\alias{kernel_normal.ts}
\alias{kernel_normal.xts}
\alias{kernel_normal.tbl_df}
\alias{kernel_normal.data.frame}
\title{Full Information by Kernel-Damping}
\usage{
kernel_normal(x, mean, sigma)

\method{kernel_normal}{default}(x, mean, sigma)

\method{kernel_normal}{numeric}(x, mean, sigma)

\method{kernel_normal}{matrix}(x, mean, sigma)

\method{kernel_normal}{ts}(x, mean, sigma)

\method{kernel_normal}{xts}(x, mean, sigma)

\method{kernel_normal}{tbl_df}(x, mean, sigma)

\method{kernel_normal}{data.frame}(x, mean, sigma)
}
\arguments{
\item{x}{An univariate or a multivariate distribution.}

\item{mean}{A numeric vector in which the kernel should be centered.}

\item{sigma}{The uncertainty (volatility) around the mean.}
}
\value{
A numerical vector of class \code{ffp} with the new
probabilities distribution.
}
\description{
Historical realizations receive a weight proportional to
their distance from a target mean.
}
\examples{
library(ggplot2)

ret <- diff(log(EuStockMarkets[ , 1]))
mean <- -0.01 # scenarios around -1\%
sigma <- var(diff(ret))

kn <- kernel_normal(ret, mean, sigma)
kn

autoplot(kn) +
  scale_color_viridis_c()

# A larger sigma spreads out the distribution
sigma <- var(diff(ret)) / 0.05
kn <- kernel_normal(ret, mean, sigma)

autoplot(kn) +
  scale_color_viridis_c()
}
\seealso{
\code{\link{crisp}} \code{\link{exp_decay}}
}
