% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ffp-ggplot2.R
\name{autoplot.ffp}
\alias{autoplot.ffp}
\alias{plot.ffp}
\title{Inspection of a \code{ffp} object with ggplot2}
\usage{
\method{autoplot}{ffp}(object, color = TRUE, ...)

\method{plot}{ffp}(object, ...)
}
\arguments{
\item{object}{An objected of the \code{ffp} class.}

\item{color}{A \code{logical} flag indicating whether (or not) the \code{color} argument
should be added to the \code{ggplot2} aesthetics.}

\item{...}{Additional arguments to be passed to \code{autoplot}.}
}
\value{
A \code{ggplot2} object.
}
\description{
Extends the \code{autoplot} method for the \code{ffp} class.
}
\examples{
library(ggplot2)

x <- exp_decay(EuStockMarkets, 0.001)
y <- exp_decay(EuStockMarkets, 0.01)

autoplot(x) +
  scale_color_viridis_c()
autoplot(y) +
  scale_color_viridis_c()
}
