\name{tabulate.ff}
\alias{tabulate.ff}
\title{Tabulation for ff vectors}
\usage{
tabulate.ff(bin, nbins = max(bin, 1, na.rm = TRUE))
}
\arguments{
  \item{bin}{factor to be binned.}

  \item{nbins}{number of bins}
}
\value{
integer vector or if \code{FFRETURN} is \code{TRUE} a
\code{ff} vector
}
\description{
\code{tabulate.ff} takes the integer-valued ff vector bin
and counts the number of times each integer occurs in it.
}
\details{
Behaviour of \code{\link{tabulate}}
}
\examples{

#create a vector of 10 million
x <- ff(vmode="integer", length=1e7)

# fill first 200 with values
x[1:100] <- 1
x[101:200] <- 2

# lets count
tabulate.ff(x)
}

