% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{get_interp}
\alias{get_interp}
\title{Extract interpolated records}
\usage{
get_interp(dt, group = NULL)
}
\arguments{
\item{dt}{a data object collected by the projection pursuit guided tour optimisation in the \code{tourr} package}

\item{group}{the variable to label different runs of the optimiser(s)}
}
\value{
a tibble object containing the interpolating bases
}
\description{
Extract interpolated records
}
\examples{
holes_1d_better \%>\%
  get_interp() \%>\%
  head()
get_interp(dplyr::bind_rows(holes_1d_better, holes_1d_geo), group = method) \%>\% head()
}
\seealso{
Other get functions: 
\code{\link{get_anchor}()},
\code{\link{get_basis_matrix}()},
\code{\link{get_best}()},
\code{\link{get_dir_search}()},
\code{\link{get_interp_last}()},
\code{\link{get_interrupt}()},
\code{\link{get_search_count}()},
\code{\link{get_search}()},
\code{\link{get_space_param}()},
\code{\link{get_start}()},
\code{\link{get_theo}()}
}
\concept{get functions}
