% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_feature_matrix.R
\name{calculate_feature_matrix}
\alias{calculate_feature_matrix}
\title{Calculate feature matrix}
\usage{
calculate_feature_matrix(entityset, features, ...)
}
\arguments{
\item{entityset}{The entityset on which to create features.}

\item{features}{The features to create based on previous runs of \link[featuretoolsR]{dfs}.}

\item{...}{Additional parameters passed to `featuretoools.calculate_feature_matrix`.}
}
\value{
A feature matrix
}
\description{
This function is used to create a feature matrix based on a custom list of features (usually created from \link[featuretoolsR]{save_features}).
}
\examples{
\donttest{
library(magrittr)

# Create some mock data
set_1 <- data.frame(key = 1:100, value = sample(letters, 100, TRUE), stringsAsFactors = TRUE)
set_2 <- data.frame(key = 1:100, value = sample(LETTERS, 100, TRUE), stringsAsFactors = TRUE)
# Common variable: `key`

# Create features and save them
as_entityset(set_1, index = "key", entity_id = "set_1", id = "demo") \%>\%
  add_entity(entity_id = "set_2", df = set_2, index = "key") \%>\%
  add_relationship(
    parent_set = "set_1",
    child_set = "set_2",
    parent_idx = "key",
    child_idx = "key"
  ) \%>\%
  dfs(target_entity = "set_1", trans_primitives = c("and")) \%>\%
  extract_features() \%>\%
  save_features(filename = "some.features")

# Re-create entityset, but rather than dfs use calcualte_feature_matrix.
es <- as_entityset(set_1, index = "key", entity_id = "set_1", id = "demo") \%>\%
  add_entity(entity_id = "set_2", df = set_2, index = "key") \%>\%
  add_relationship(
    parent_set = "set_1",
    child_set = "set_2",
    parent_idx = "key",
    child_idx = "key"
  )
calculate_feature_matrix(entityset = es, features = load_features("some.features"))
}
}
