% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elastic_changepoint.R
\name{elastic_change_fpca}
\alias{elastic_change_fpca}
\title{Elastic Changepoint Detection}
\usage{
elastic_change_fpca(
  f,
  time,
  pca.method = "combined",
  pc = 0.95,
  d = 1000,
  n_pcs = 5,
  smooth_data = FALSE,
  sparam = 25,
  showplot = TRUE
)
}
\arguments{
\item{f}{matrix (\eqn{N} x \eqn{M}) of \eqn{M} functions with \eqn{N} samples}

\item{time}{vector of size \eqn{N} describing the sample points}

\item{pca.method}{string specifying pca method (options = "combined",
"vert", or "horiz", default = "combined")}

\item{pc}{percentage of cummulation explained variance (default = 0.95)}

\item{d}{number of monte carlo iterations of Brownian Bridge (default = 1000)}

\item{n_pcs}{scalar specify number of principal components (default = 5)}

\item{smooth_data}{smooth data using box filter (default = F)}

\item{sparam}{number of times to apply box filter (default = 25)}

\item{showplot}{show results plots (default = T)}
}
\value{
Returns a list object containing
\item{pvalue}{p value}
\item{change}{indice of changepoint}
\item{DataBefore}{functions before changepoint}
\item{DataAfter}{functions after changepoint}
\item{MeanBefore}{mean function before changepoint}
\item{MeanAfter}{mean function after changepoint}
\item{WarpingBefore}{warping functions before changepoint}
\item{WarpingAfter}{warping functions after changepoint}
\item{WarpingMeanBefore}{mean warping function before changepoint}
\item{WarpingMeanAfter}{mean warping function after changepoint}
\item{change_fun}{amplitude change function}
\item{Sn}{test statistic values}
}
\description{
This function identifies changepoints using a functional PCA
}
\references{
J. D. Tucker and D. Yarger, “Elastic Functional Changepoint
Detection of Climate Impacts from Localized Sources”, Envirometrics,
10.1002/env.2826, 2023.
}
\keyword{alignment}
\keyword{changepoint}
\keyword{srvf}
