% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivariate_karcher_mean.R
\name{multivariate_karcher_mean}
\alias{multivariate_karcher_mean}
\title{Karcher Mean of Multivariate Functional Data}
\usage{
multivariate_karcher_mean(beta, lambda = 0, maxit = 20, ms = "mean")
}
\arguments{
\item{beta}{\eqn{L \times M \times N} and it is
interpreted as a sample of \eqn{N} \eqn{L}-dimensional curves observed on a
grid of size \eqn{M}.}

\item{lambda}{A numeric value specifying the elasticity. Defaults to \code{0.0}.}

\item{maxit}{maximum number of iterations}

\item{ms}{string defining whether the Karcher mean (\code{"mean"}) or Karcher
median (\code{"median"}) is returned (default = \code{"mean"})}
}
\value{
Returns a list containing \item{mu}{mean srvf}
\item{betamean}{mean or median curve}
\item{type}{string indicating whether mean or median is returned}
\item{betan}{aligned curves}
\item{q}{array of srvfs}
\item{qn}{array of aligned srvfs}
\item{gam}{array of warping functions}
\item{E}{energy}
\item{qun}{cost function}
}
\description{
Calculates Karcher mean or median of a collection of multivariate functional
data using the elastic square-root velocity (srvf) framework.
}
\examples{
out <- multivariate_karcher_mean(beta[, , 1, 1:2], maxit = 2)
# note: use more functions, small for speed
}
\references{
Srivastava, A., Klassen, E., Joshi, S., Jermyn, I., (2011). Shape
analysis of elastic curves in euclidean spaces. Pattern Analysis and Machine
Intelligence, IEEE Transactions on 33 (7), 1415-1428.
}
\keyword{alignment}
\keyword{srvf}
