% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gauss_model.R
\name{gauss_model}
\alias{gauss_model}
\title{Gaussian model of functional data}
\usage{
gauss_model(warp_data, n = 1, sort_samples = FALSE)
}
\arguments{
\item{warp_data}{fdawarp object from \link{time_warping} of aligned data}

\item{n}{number of random samples (n = 1)}

\item{sort_samples}{sort samples (default = F)}
}
\value{
Returns a fdawarp object containing \item{fs}{random aligned samples}
\item{gams}{random warping function samples}
\item{ft}{random function samples}
}
\description{
This function models the functional data using a Gaussian model extracted from
the principal components of the srvfs
}
\examples{
data("simu_warp")
out1 = gauss_model(simu_warp,n = 10)
}
\references{
Tucker, J. D., Wu, W., Srivastava, A.,
 Generative Models for Function Data using Phase and Amplitude Separation,
 Computational Statistics and Data Analysis (2012), 10.1016/j.csda.2012.12.001.
}
\keyword{pca}
