% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FPCAder.R
\name{FPCAder}
\alias{FPCAder}
\title{Take derivative of an FPCA object}
\usage{
FPCAder(fpcaObj, derOptns = list(p = 1))
}
\arguments{
\item{fpcaObj}{A object of class FPCA returned by the function FPCA().}

\item{derOptns}{A list of options to control the derivation parameters specified by \code{list(name=value)}. See `Details'. (default = NULL)}
}
\description{
Take derivative of an FPCA object
}
\details{
Available derivation control options are 
\describe{
\item{method}{The method used for obtaining the derivatives. 'DPC': cite, 'FPC': cite}
\item{p}{The order of the derivatives returned (default: 0, max: 2)}
\item{bw}{Bandwidth for smoothing the derivatives (default: p * 0.1 * S). For 'DPC', bw is used for smoothing G^(1,1)(s,t)}
\item{kernelType}{Smoothing kernel choice; same available types are FPCA(). default('epan')}
}
}
\examples{
set.seed(1)
n <- 20
pts <- seq(0, 1, by=0.05)
sampWiener <- Wiener(n, pts)
sampWiener <- Sparsify(sampWiener, pts, 10)
res <- FPCA(sampWiener$Ly, sampWiener$Lt, 
            list(dataType='Sparse', error=FALSE, kernel='epan', verbose=TRUE))
derRes <- FPCAder(res)
}

