% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_distribution.R
\name{obtain_suface_L2_norm}
\alias{obtain_suface_L2_norm}
\title{Obtain L2 norm of the autocovariance functions}
\usage{
obtain_suface_L2_norm(v, autocovSurface)
}
\arguments{
\item{v}{Discretization points of the curves, by default
\code{seq(from = 0, to = 1, length.out = 100)}.}

\item{autocovSurface}{An \eqn{(m x m)} matrix with
the discretized values of the autocovariance operator
\eqn{\hat{C}_{0}}, obtained by calling the
function \code{obtain_autocovariance}. The value
\eqn{m} indicates the number of points observed in
each curve.}
}
\value{
A vector containing the L2 norm of the
lagged autocovariance functions \code{autocovSurface}.
}
\description{
Returns the L2 norm of the lagged autocovariance
functions \eqn{\hat{C}_{h}}. The L2 norm of these
functions is defined as
\deqn{\sqrt(\int \int \hat{C}^{2}_{h}(u,v)du dv)}
}
\examples{
# Example 1

N <- 100
v <- seq(from = 0, to = 1, length.out = 10)
sig <- 2
Y <- simulate_iid_brownian_bridge(N, v, sig)
nlags <- 1
autocovSurface <- obtain_autocovariance(Y=Y,nlags = nlags)
norms <- obtain_suface_L2_norm(v = v,autocovSurface = autocovSurface)
plot_autocovariance(fun.autocovariance = autocovSurface,lag = 1)
title(sub = paste0("Lag ",1," - L2 Norm: ",norms[2]))

\donttest{
# Example 2

N <- 400
v <- seq(from = 0, to = 1, length.out = 50)
sig <- 2
Y <- simulate_iid_brownian_bridge(N, v, sig)
nlags <- 2
autocovSurface <- obtain_autocovariance(Y=Y,nlags = nlags)
norms <- obtain_suface_L2_norm(v = v,autocovSurface = autocovSurface)
opar <- par(no.readonly = TRUE)
par(mfrow = c(1,3))
plot_autocovariance(fun.autocovariance = autocovSurface,lag = 0)
title(sub = paste0("Lag ",0," - L2 Norm: ",norms[1]))
plot_autocovariance(fun.autocovariance = autocovSurface,lag = 1)
title(sub = paste0("Lag ",1," - L2 Norm: ",norms[2]))
plot_autocovariance(fun.autocovariance = autocovSurface,lag = 2)
title(sub = paste0("Lag ",2," - L2 Norm: ",norms[3]))
par(opar)
}
}
