% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fdata2pc.R
\name{fdata2pc}
\alias{fdata2pc}
\title{Principal components for functional data}
\usage{
fdata2pc(fdataobj, ncomp = 2, norm = TRUE, lambda = 0, P = c(0, 0, 1), ...)
}
\arguments{
\item{fdataobj}{\code{\link{fdata}} class object.}

\item{ncomp}{Number of principal comoponents.}

\item{norm}{=TRUE the norm of eigenvectors \code{(rotation)} is 1.}

\item{lambda}{Amount of penalization. Default value is 0, i.e. no
penalization is used.}

\item{P}{If P is a vector: coefficients to define the penalty matrix object.
By default P=c(0,0,1) penalize the second derivative (curvature) or
acceleration.  If P is a matrix: the penalty matrix object.}

\item{\dots}{Further arguments passed to or from other methods.}
}
\value{
\itemize{
\item {d}{ The standard deviations of the functional principal components.} 
\item {rotation}{ are also known as loadings.  A \code{fdata} class object whose rows contain the eigenvectors.} 
\item {x}{ are also known as scores. The value of the rotated functional data is returned.}
\item {fdataobj.cen}{ The centered \code{fdataobj} object.} 
\item {mean}{ The functional mean of \code{fdataobj} object.} 
\item {l}{ Vector of index of principal components.} 
\item {C}{ The matched call.} 
\item {lambda}{ Amount of penalization.} 
\item {P}{ Penalty matrix.}
}
}
\description{
Compute (penalized) principal components for functional data.
}
\details{
Smoothing is achieved by penalizing the integral of the square of the
derivative of order m over rangeval: \itemize{ \item m = 0 penalizes the
squared difference from 0 of the function \item m = 1 penalize the square of
the slope or velocity \item m = 2 penalize the squared acceleration \item m
= 3 penalize the squared rate of change of acceleration }
}
\examples{
 \dontrun{
 n= 100;tt= seq(0,1,len=51)
 x0<-rproc2fdata(n,tt,sigma="wiener")
 x1<-rproc2fdata(n,tt,sigma=0.1)
 x<-x0*3+x1
 pc=fdata2pc(x,lambda=1)
 summary(pc)
 }
}
\references{
Venables, W. N. and B. D. Ripley (2002). \emph{Modern Applied
Statistics with S}. Springer-Verlag.

N. Kraemer, A.-L. Boulsteix, and G. Tutz (2008). Penalized Partial Least
Squares with Applications to B-Spline Transformations and Functional Data.
Chemometrics and Intelligent Laboratory Systems, 94, 60 - 69.
\url{http://dx.doi.org/10.1016/j.chemolab.2008.06.009}

Febrero-Bande, M., Oviedo de la Fuente, M. (2012).  \emph{Statistical
Computing in Functional Data Analysis: The R Package fda.usc.} Journal of
Statistical Software, 51(4), 1-28. \url{http://www.jstatsoft.org/v51/i04/}
}
\seealso{
See Also as \link[base]{svd} and \link[stats]{varimax}.
}
\author{
Manuel Febrero-Bande, Manuel Oviedo de la Fuente
\email{manuel.oviedo@usc.es}
}
\keyword{multivariate}
