% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parser.R
\name{parse_implications}
\alias{parse_implications}
\title{Parses several implications given as a string}
\usage{
parse_implications(input)
}
\arguments{
\item{input}{(character) The string with the implications or a file containing the implications}
}
\value{
An ImplicationSet
}
\description{
Parses several implications given as a string
}
\details{
The format for the input file is:
\itemize{
\item Every implication in its own line or separated by semicolon (;)
\item Attributes are separated by commas (,)
\item The LHS and RHS of each implication are separated by an arrow (->)
}
}
\examples{
input <- system.file("implications", "ex_implications", package = "fcaR")
imps <- parse_implications(input)

}
