% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net.caveman.R
\name{net.caveman}
\alias{net.caveman}
\title{Caveman Network}
\usage{
net.caveman(m, k, ncores = detectCores())
}
\arguments{
\item{m}{Number of cliques (or caves) in the network.}

\item{k}{Number of nodes per clique.}

\item{ncores}{Number of cores, by default \code{detectCores()} from \code{parallel}.}
}
\value{
A list containing the nodes of the network and their respective neighbors.
}
\description{
Simulate a (connected) caveman network of \emph{m} cliques of size \emph{k}.
}
\details{
The (connected) caveman network is formed by connecting a set of isolated \emph{k} - cliques
(or "caves"), neighbor by neighbor and head to toe,  using one edge that removed from each
clique such that all \emph{m} cliques form a single circle (Watts 1999). The total number of nodes, i.e. \emph{n}, in this network is given by \eqn{k*m}.
}
\examples{
\dontrun{
x <- net.caveman(50, 20) #using ncores by default }
}
\author{
Xu Dong, Nazrul Shaikh.
}
\references{
Watts, D. J. Networks, Dynamics, and the Small-World Phenomenon. Amer. J. Soc. 105, 493-527, 1999.
}

