% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metric.eigen.mean.R
\name{metric.eigen.mean}
\alias{metric.eigen.mean}
\title{Mean Eigenvalue Centrality}
\usage{
metric.eigen.mean(g)
}
\arguments{
\item{g}{The input network.}
}
\value{
A real constant.
}
\description{
Calculate the mean eigenvalue centrality of a graph.
}
\details{
\code{metric.eigen.mean} calculates the mean eigenvalue centrality score of graph \emph{g}.
}
\examples{
\dontrun{
x <-  net.erdos.renyi.gnp(1000, 0.01)
metric.eigen.mean(x)}
}
\author{
Xu Dong, Nazrul Shaikh.
}
\references{
Bonacich, Phillip, and Paulette Lloyd. "Eigenvector-like measures of centrality for asymmetric relations." Social networks 23, no. 3 (2001): 191-201.

Borgatti, Stephen P. "Centrality and network flow." Social networks 27, no. 1 (2005): 55-71.
}

