% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zonal.r
\name{zonal,GRaster,ANY-method}
\alias{zonal,GRaster,ANY-method}
\alias{zonal}
\title{Statistics on cells of a GRaster stratified by cells of another raster}
\usage{
\S4method{zonal}{GRaster,ANY}(x, z, fun = "mean", probs = 0.5)
}
\arguments{
\item{x}{A \code{GRaster} for which to calculate summary statistics.}

\item{z}{A \code{GRaster} or \code{GVector} used to define zones:
\itemize{
\item If \code{z} is a \code{GRaster}, then it must be of type \code{integer} or \code{factor} (see \code{vignette("GRasters", package = "fasterRaster")}). Zones will be established based on cells that have the same value in this raster.
\item If \code{z} is a \code{GVector}, zones will be created for each geometry. If geometries overlap, then the zonal statistics will be calculated for the ones on top. Thus statistics for the zones defined by geometries below these may not represent all the cells covered by that geometry.
}}

\item{fun}{Character vector: Name of the function(s) to summarize \code{x} with. These can include:
\itemize{
\item \code{"*"}: All of the functions below.
\item \code{"cv"}: Sample coefficient of variation (expressed as a proportion of the mean).
\item \code{"cvpop"}: Population coefficient of variation (expressed as a proportion of the mean).
\item \code{"max"} and \code{"min"}: Highest and lowest values across non-\code{NA} cells.
\item \code{"mean"} (default): Average.
\item \code{"meanAbs"}: Mean of absolute values.
\item \code{"median"}: Median.
\item \code{"quantile"}: Quantile (see also argument \code{probs}).
\item \code{"range"}: Range.
\item \code{"sd"}: Sample standard deviation.
\item \code{"sdpop"}: Population standard deviation.
\item \code{"sum"}: Sum.
\item \code{"var"}: Sample variance.
\item \code{"varpop"}: Population variance.
}}

\item{probs}{Numeric: Quantile at which to calculate \code{quantile}. Only a single value between 0 and 1 is allowed.}
}
\value{
A \code{data.frame} or \code{data.table}.
}
\description{
Function \code{zonal()} calculates statistics (mean, sum, etc.) on cells of a \code{GRaster} by "zones" created by cells of another \code{GRaster} or \code{GVector}.
}
\examples{
if (grassStarted()) {

# Setup
library(terra)

# Elevation SpatRaster:
madElev <- fastData("madElev")

# Convert a SpatRaster to a GRaster:
elev <- fast(madElev)

### Calculate zonal statistics using a GRaster as zones

# Generate a "zones" GRaster by dividing raster into areas based on
# high/low elevation.
names(elev) # Use this name in app() formula.
fun <- "= if (madElev <200, 0, if (madElev <400, 1, 2))"
zones <- app(elev, fun = fun)

# Calculate zonal statistics using a raster as zones
zonal(elev, zones, fun = "mean")
zonal(elev, zones, fun = "*") # all statistics

# Calculate zonal statistics on multi-layered GRaster
elev2 <- c(elev, log10(elev))
zonal(elev2, zones, fun = c("mean", "sum", "sdpop"))

### Calculate zonal statistics using a GVector as zones

madCoast4 <- fastData("madCoast4")
coast <- fast(madCoast4)

zonal(elev, z = coast, fun = "mean")

}
}
