% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvoronoi.r
\name{rvoronoi,GRaster-method}
\alias{rvoronoi,GRaster-method}
\alias{rvoronoi}
\alias{rvoronoi,GVector-method}
\title{Create a randomly-positioned tesselation}
\usage{
\S4method{rvoronoi}{GRaster}(x, size = 100, seed = NULL)

\S4method{rvoronoi}{GVector}(x, size = 100, seed = NULL)
}
\arguments{
\item{x}{A \code{GRaster} or \code{GVector} used to constrain the location of random points used to create the tesselation.}

\item{size}{Numeric integer or integer: Number of polygons.}

\item{seed}{Numeric integer, integer, or \code{NULL} (default): Value used as a random seed. If \code{NULL}, a random seed will be generated by \strong{GRASS}.}
}
\value{
A \code{GVector}.
}
\description{
This function partitions a region into Voronoi polygons that completely overlap it. Each polygon has a random center. The function is essentially a wrapper for \code{\link[=spatSample]{spatSample()}} and \code{\link[=voronoi]{voronoi()}}.
}
\examples{
if (grassStarted()) {

# Setup
library(sf)

# Example vectors
madDypsis <- fastData("madDypsis") # points
madCoast4 <- fastData("madCoast4") # polygons

# Convert sf vectors to GVectors
dypsis <- fast(madDypsis)
coast4 <- fast(madCoast4)
ant <- coast4[coast4$NAME_4 == "Antanambe"]

# Delaunay triangulation
dypsisDel <- delaunay(dypsis)
plot(dypsisDel)
plot(dypsis, pch = 1, col = "red", add = TRUE)

# Voronoi tessellation
vor <- voronoi(dypsis)
plot(vor)
plot(dypsis, pch = 1, col = "red", add = TRUE)

# Random Voronoi tessellation
rand <- rvoronoi(coast4, size = 100)
plot(rand)

}
}
