% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastcpd_data.R
\docType{data}
\name{bitcoin}
\alias{bitcoin}
\title{Bitcoin Market Price (USD)}
\format{
A data frame with 1354 rows and 2 variables:
\describe{
\item{date}{POSIXct,POSIXt (TZ: "UTC") from 2019-01-02 to 2023-10-28}
\item{price}{The average USD market price across major bitcoin exchanges}
}
}
\source{
<https://www.blockchain.com/explorer/charts/market-price>
}
\usage{
bitcoin
}
\description{
The average USD market price across major bitcoin exchanges.
}
\examples{
\donttest{
ggplot2::ggplot(bitcoin, ggplot2::aes(x = date, y = price)) +
  ggplot2::geom_line()

result <- suppressWarnings(fastcpd.garch(
  diff(log(bitcoin$price[600:900])), c(1, 1),
  beta = "BIC", cost_adjustment = "BIC"
))
summary(result)
bitcoin$date[result@cp_set + 600]
plot(result)

cp_dates <- bitcoin[600 + result@cp_set + 1, "date"]
ggplot2::ggplot(
  data = data.frame(
    x = bitcoin$date[600:900], y = bitcoin$price[600:900]
  ),
  ggplot2::aes(x = x, y = y)
) +
  ggplot2::geom_line(color = "steelblue") +
  ggplot2::geom_vline(
    xintercept = cp_dates,
    color = "red",
    linetype = "dotted",
    linewidth = 0.5,
    alpha = 0.7
  ) +
  ggplot2::labs(
    x = "Year",
    y = "Bitcoin price in USD"
  ) +
  ggplot2::annotate(
    "text",
    x = cp_dates,
    y = 2000,
    label = as.character(cp_dates),
    color = "steelblue"
  ) +
  ggplot2::theme_bw()
}
}
\keyword{datasets}
