% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_plots.R
\name{loadings_plot}
\alias{loadings_plot}
\alias{loadings_plot_ggplot_call}
\title{Loadings Plot}
\usage{
loadings_plot(
  fit,
  x,
  k,
  ggplot_call = loadings_plot_ggplot_call,
  plot_grid_call = function(plots) do.call(plot_grid, plots)
)

loadings_plot_ggplot_call(dat, topic.label, font.size = 9)
}
\arguments{
\item{fit}{An object of class \dQuote{poisson_nmf_fit} or
\dQuote{multinom_topic_model_fit}.}

\item{x}{A categorical variable represented as a
\code{\link{factor}}. It should have the same number of elements as
the number of rows in \code{fit$L}.}

\item{k}{The topic, or topics, selected by number or name. When not
specified, all topics are plotted.}

\item{ggplot_call}{The function used to create the plot. Replace
\code{loadings_plot_ggplot_call} with your own function to
customize the appearance of the plot.}

\item{plot_grid_call}{When multiple topics are selected, this is
the function used to arrange the plots into a grid using
\code{\link[cowplot]{plot_grid}}. It should be a function accepting
a single argument, \code{plots}, a list of \code{ggplot} objects.}

\item{dat}{A data frame passed as input to
\code{\link[ggplot2]{ggplot}}, containing, at a minimum, columns
\dQuote{x} and \dQuote{loading}.}

\item{topic.label}{The name or number of the topic being plotted.
Only used to determine the plot title.}

\item{font.size}{Font size used in plot.}
}
\value{
A \code{ggplot} object.
}
\description{
Generate one or more barcharts to visualize the
  relationship between the loadings or mixture proportions and a
  selected categorical variable (a factor).
}
\details{
This is a lightweight interface primarily intended to
  expedite creation of boxplots for investigating relationships
  between topics and a categorical variables of interest without
  having to spend a great deal of time worrying about the plotting
  settings; most of the \dQuote{heavy lifting} is done by
  \sQuote{ggplot2} (specifically, function
  \code{\link[ggplot2]{geom_boxplot}} in the \sQuote{ggplot2}
  package). For more control over the plot's appearance, the plot can
  be customized by modifying the \code{ggplot_call} and
  \code{plot_grid_call} arguments.
}
