% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction.R
\name{predict.fastTS}
\alias{predict.fastTS}
\title{Predict function for fastTS object}
\usage{
\method{predict}{fastTS}(
  object,
  n_ahead = 1,
  X_test,
  y_test,
  cumulative = FALSE,
  forecast_ahead = FALSE,
  return_intermediate = FALSE,
  ...
)
}
\arguments{
\item{object}{an fastTS object}

\item{n_ahead}{the look-ahead period for predictions}

\item{X_test}{a matrix exogenous features for future predictions (optional)}

\item{y_test}{the test series for future predictions (optional)}

\item{cumulative}{cumulative (rolling) sums of 1-, 2-, 3-, ..., k-step-ahead
predictions.}

\item{forecast_ahead}{returns forecasted values for end of training series}

\item{return_intermediate}{if TRUE, returns the intermediate predictions between
the 1st and n_ahead predictions, as data frame.}

\item{...}{currently unused}
}
\value{
a vector of predictions, or a matrix of 1- through n_ahead predictions.
}
\description{
Predict function for fastTS object
}
\details{
The `y_test` argument must be supplied if predictions are desired or if
`n_ahead` < `nrow(X_test)`. This is because in order to obtain 1-step
forecast for, say, the 10th observation in the test data set, the 9th
observation of `y_test` is required.

Forecasts for the first
`n_ahead` observations after the training set can be obtained by setting
`forecast_ahead` to TRUE, which will return the forecasted values at
the end of the training data. it produces the 1-step-ahead prediction,
the 2-step-ahead prediction, ... through the `n_ahead`-step prediction.
The `cumulative` argument is similar but will return the cumulative (rolling)
sums of 1-, 2-, 3=, ..., `n_ahead`-step-ahead predictions.
}
\examples{
data("LakeHuron")
fit_LH <- fastTS(LakeHuron)
predict(fit_LH)

}
