% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastMatMR-package.R
\name{fmm_to_vec}
\alias{fmm_to_vec}
\title{Convert Matrix Market File to Numeric Vector}
\usage{
fmm_to_vec(filename)
}
\arguments{
\item{filename}{The name of the input Matrix Market file to be read.}
}
\value{
A numeric vector containing the data read from the Matrix Market
file.
}
\description{
This function reads a Matrix Market file and converts it to a
numeric vector in R.
}
\examples{
# Create
sample_vec <- c(1, 2, 3)
temp_file_vec <- tempfile(fileext = ".mtx")
write_fmm(sample_vec, temp_file_vec)
# Read
vec <- fmm_to_vec(temp_file_vec)
}
