% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_fsvdraws.R
\name{covmat.fsvdraws}
\alias{covmat.fsvdraws}
\title{Extract posterior draws of the model-implied covariance matrix}
\usage{
\method{covmat}{fsvdraws}(x, ...)
}
\arguments{
\item{x}{Object of class \code{'fsvdraws'}, usually resulting from a call
of \code{\link{fsvsample}}.}

\item{...}{Ignored.}
}
\value{
Array of dimension \code{m} times \code{m} times \code{draws}
times \code{timepoints} containing the posterior draws for the
model-implied covariance matrix.
}
\description{
\code{covmat} extracts draws from the model-implied covariance matrix
from an \code{fsvdraws} object for all points in time which have been
stored.
}
\note{
Currently crudely implemented as a double loop in pure R,
may be slow.
}
\examples{
\dontrun{
set.seed(1)
sim <- fsvsim(n = 500, series = 3, factors = 1) # simulate 
res <- fsvsample(sim$y, factors = 1, keeptime = "all") # estimate
covs <- covmat(res) # extract

# Trace plot of determinant of posterior covariance matrix
# at time t = n = 500:
detdraws <- apply(covs[,,,500], 3, det)
ts.plot(detdraws)
abline(h = mean(detdraws), col = 2)          # posterior mean
abline(h = median(detdraws), col = 4)        # posterior median
abline(h = det(covmat(sim)[,,500]), col = 3) # implied by DGP

# Trace plot of draws from posterior covariance of Sim1 and Sim2 at
# time t = n = 500:
ts.plot(covs[1,2,,500])
abline(h = covmat(sim)[1,2,500], col = 3) # "true" value

# Smoothed kernel density estimate:
plot(density(covs[1,2,,500], adjust = 2))

# Summary statistics:
summary(covs[1,2,,500])
}

}
\seealso{
covmat covmat.fsvsim

Other extractors: \code{\link{runningcormat}},
  \code{\link{runningcovmat}}
}

