% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variable_creation_functions.R
\name{split_quantile}
\alias{split_quantile}
\title{Split data into quantile buckets (e.g. terciles, quartiles, quantiles,
deciles).}
\usage{
split_quantile(x = NULL, type = NULL)
}
\arguments{
\item{x}{A vector of any type that can be ordered -- i.e. numeric or factor
where factor levels are ordered.}

\item{type}{The number of buckets to split data into. For a median split,
enter 2; for terciles, enter 3; for quartiles, enter 4; for quintiles, 5;
for deciles, 10.}
}
\description{
Survey data is often presented in aggregated, depersonalized form, which
can involve binning underlying data into quantile buckets; for example,
rather than reporting underlying income, a survey might report income by
decile. `split_quantile` can automatically produce this split using any
data `x` and any number of splits `type.
}
\examples{

# Divide this arbitrary data set in 3.
data_input <- rnorm(n = 100)
split_quantile(x = data_input, type = 3)

}
