% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/features.R
\name{register_feature}
\alias{register_feature}
\title{Register a feature function}
\usage{
register_feature(fn, tags)
}
\arguments{
\item{fn}{The feature function}

\item{tags}{Identifying tags}
}
\description{
Allows users to find and use features from your package using \code{\link[=feature_set]{feature_set()}}.
If the features are being registered from within a package, this feature
registration should happen at load time using \verb{[.onLoad()]}.
}
\examples{

\dontrun{
tukey_five <- function(x){
  setNames(fivenum(x), c("min", "hinge_lwr", "med", "hinge_upr", "max"))
}

register_feature(tukey_five, tags = c("boxplot", "simple"))

}

}
