% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fable.R, R/hilo.R, R/quantile.R
\name{hilo.fbl_ts}
\alias{hilo.fbl_ts}
\alias{hilo}
\alias{hilo.fcdist}
\title{Compute hilo intervals}
\usage{
\method{hilo}{fbl_ts}(x, level = c(80, 95), ...)

hilo(x, ...)

\method{hilo}{fcdist}(x, level = 95, ...)
}
\arguments{
\item{x}{Object to create hilo from}

\item{level}{The confidence levels for the plotted prediction intervals.}

\item{...}{Additional arguments for the distribution's quantile function.}
}
\description{
Used to extract a specified prediction interval at a particular confidence
level from a distribution or fable.
}
\examples{

dist_normal(10, 3) \%>\% hilo(95)

if (requireNamespace("fable", quietly = TRUE)) {
library(fable)
library(tsibbledata)
library(dplyr)
aus_production \%>\%
  model(ets = ETS(log(Beer) ~ error("M") + trend("Ad") + season("A"))) \%>\% 
  forecast(h = "3 years") \%>\% 
  mutate(interval = hilo(.distribution, 95))
}
}
